package com.izenpe.zain.cliente.crypt;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartDecryptRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartDecryptResponse;

public class DescifradoCMS {
	
	// Nombre del fichero que vamos a Encriptar
	private static final String fileName = "Cifrado-descifrado.txt.cms";

	public static void main(String args[]) {
		try {
			// Asignacin de la configuracin de forma programtica
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);
			
			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartDecryptRequest smartDecryptRequest = new SmartDecryptRequest(Propiedades.ZAIN_ENDPOINT);
			
			/*
			 * Se selecciona el tipo de cifrado CMS/PKCS#7
			 */
			smartDecryptRequest.setProfile(Constants.Profile.CMSPKCS7);
			
			/*
			 * Datos a cifrar
			 */
			smartDecryptRequest.setEnvelopeBase64(Base64.encode(ZainUtil.readBinaryFile("data/input/" + fileName)));
			
			// Envo de la peticin.
			SmartDecryptResponse smartDecryptResponse = smartDecryptRequest.send();
			
			if (Constantes.RMAJOR_SUCCESS.equals((smartDecryptResponse.getResultMajor()))
					&& smartDecryptResponse.getResultMinor() == null) {
				//Guardamos los datos desencriptados
				String decryptBase64 = smartDecryptResponse.getDocumentBase64Data();
				byte[] data = Base64.decode(decryptBase64);
				String destFilename = "data/input/decryption-" + fileName;
				ZainUtil.writeBinaryFile(destFilename, data);
				System.out.println("Decryption OK");
			} else {
				System.out.println("Error durante el Descifrado: " + smartDecryptResponse.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}